//
//		Definition of the main game class
//
#ifndef THE_LOADING_SCENE_H
#define THE_LOADING_SCENE_H


#include "ldwScene.h"
#include "../World/WorldMap.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"
#include "../Utils/theStringManager.h"
#define cLocalMeterThickness 23
#define cLocalMeterFullWidth 151
#define cLoadingScreenWidth 800
#define cLoadingMeterX 240
#define cLoadingMeterY 500

class ldwButton;
class ldwSoundTrack;
class ldwSoundFx;
class theGameState;
class ldwTextControl;
class theVariableMeter;

class theLoadingScene : public ldwScene
{
public:

	theLoadingScene();
	~theLoadingScene();
	void SetTimer();
	bool HandleKey(int messageId,int keyCode,int character);
	bool HandleMouse(int messageId,ldwPoint location);
	bool HandleMessage(int messageId,long data);
	void SetMeter(int value);
protected:

	void DrawScene();
	void UpdateScene();

private:
	ldwUINT32 timer;
	ldwGameWindow *gameWindow;
	theGameState  *gs;
	theVariableMeter *variableMeter;
	theStringManager *strMgr;
	int handAdjX;
	int handAdjY;
	
	int meterValue;

	bool customCursor;
	bool hideCursor;
};
#endif